const WebSocket = require('ws');
const wss = new WebSocket.Server({ port: 203 });

console.log("WebSocket server berjalan di ws://localhost:203");

let lastState = {
  servo: 0,
  motor: "off"
};

// Broadcast ke semua klien
function broadcast(data) {
  wss.clients.forEach(client => {
    if (client.readyState === WebSocket.OPEN) {
      client.send(JSON.stringify(data));
    }
  });
}

wss.on('connection', ws => {
  console.log("Client Terhubung");

  // Kirim state terakhir ke client baru
  ws.send(JSON.stringify(lastState));

  ws.on('message', message => {
    console.log("Pesan diterima:", message.toString());

    try {
      const data = JSON.parse(message.toString());

      if (data.servo !== undefined) {
        lastState.servo = data.servo;
      }

      if (data.motor !== undefined) {
        lastState.motor = data.motor;
      }

      // Broadcast ke semua klien (termasuk ESP32)
      broadcast(lastState);

    } catch (err) {
      console.log("JSON error:", err);
    }
  });

  ws.on('close', () => console.log("Client Terputus"));
});
